<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SaleStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $data = [
            'order_type' => 'required',
            'customer_id' => 'required',
            'cart_total_cost' => 'required',
            'cart_total_items' => 'required',
            'cart_total_price' => 'required',
            'profit_after_all' => 'required',
            'items' => 'required',
            'tax' => 'required',
            'tax_amount' => 'required',
            'progress' => 'required',
            'payment_note' => 'sometimes',
            'staff_note' => 'sometimes',
            'note_for_chef' => 'sometimes',
            'chef_id' => 'sometimes',
            'prepared_at' => 'sometimes',
            'order_taker_id' => 'sometimes',
            'took_at' => 'sometimes',
            'is_spliting' => 'sometimes',
            'discount_amount' => 'sometimes',
            'discount_rate' => 'sometimes',
            'is_discount_in_percentage' => 'sometimes',
            'payable_after_all' => 'required',
        ];

        if (request('order_type') === 'dining') {
            $data['table_id'] = 'required|exists:service_tables,id';
        }
        if (request('order_type') === 'pickup') {
            $data['pickup_point_id'] = 'nullable|exists:pickup_points,id';
        }
        if (request('order_type') === 'dilivery') {
            $data['shipping_address'] = 'nullable';
        }

        return $data;
    }

    public function messages(): array
    {
        return [
            'customer_id.required' => __('Customer is required'),
            'table_id.required' => __('Service table is required for dinning order'),
            'table_id.exists' => __('No user was found with this e-mail address'),
        ];
    }
}
