<?php

namespace App\Http\Resources;

use App\Http\Resources\SaleHistoryResource;
use Illuminate\Http\Resources\Json\JsonResource;

class PosCustomerResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'uuid' => $this->uuid,
            'full_name' => $this->name . ' ', $this->email . ' ' . $this->phone,
            'name' => $this->name,
            'email' => $this->email,
            'address' => $this->address,
            'phone' => $this->phone,
            'shipping_addresses' => $this->shipping_addresses ?? [],
            'history' => SaleHistoryResource::collection($this->sales),
            'created_at' => $this->created_at->format(config('app.app_date_format')),
            'updated_at' => $this->updated_at->format(config('app.app_date_format')),
        ];
    }
}
