<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            $table->string('print_font_family')->default('monospace');
            $table->string('print_name_address_position')->default('left');
            $table->string('print_name_address_size')->default(17);
            $table->string('print_header_footer_size')->default(14);
            $table->string('print_items_font_size')->default(8);
            $table->string('print_terms_conditions_font_size')->default(7);
            $table->string('print_font_color')->default('#00000');
            $table->string('printer_width')->default('100mm');
            $table->string('printer_height')->default('170mm');
            $table->boolean('signature_required')->default(false);
            $table->longText('terms_conditions')->nullable();
            $table->boolean('print_auto')->default(true);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            $table->dropColumn('print_font_family');
            $table->dropColumn('print_name_address_position');
            $table->dropColumn('print_name_address_size');
            $table->dropColumn('print_header_footer_size');
            $table->dropColumn('print_items_font_size');
            $table->dropColumn('print_terms_conditions_font_size');
            $table->dropColumn('print_font_color');
            $table->dropColumn('printer_width');
            $table->dropColumn('printer_height');
            $table->dropColumn('signature_required');
            $table->dropColumn('terms_conditions');
            $table->dropColumn('print_auto');
        });
    }
};
