<?php

use App\Http\Controllers\AppController;
use App\Models\FoodCategory;
use App\Models\FoodItem;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Str;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */
if (config('app.demo_mode')) {
    Route::get('bc-up', function () {
        $categoriesWithProducts = [
            [
                'name' => "Appetizers",
                'products' => [
                    "Spinach Artichoke Dip",
                    "Chicken Wings",
                    "Mozzarella Sticks",
                    "Nachos",
                    "Bruschetta",
                    "Potato Skins",
                    "Stuffed Mushrooms",
                    "Buffalo Cauliflower",
                    "Fried Calamari",
                    "Jalapeno Poppers",
                ],
            ],
            [
                'name' => "Soups",
                'products' => [
                    "Tomato Soup",
                    "Chicken Noodle Soup",
                    "Lentil Soup",
                    "Clam Chowder",
                    "Miso Soup",
                    "Minestrone Soup",
                    "French Onion Soup",
                    "Creamy Mushroom Soup",
                    "Spicy Seafood Soup",
                    "Thai Coconut Soup",
                ],
            ],
            [
                'name' => "Salads",
                'products' => [
                    "Caesar Salad",
                    "Greek Salad",
                    "Cobb Salad",
                    "Caprese Salad",
                    "Spinach Salad",
                    "Waldorf Salad",
                    "Mediterranean Salad",
                    "Chicken Caesar Salad",
                    "Quinoa Salad",
                    "Asian Sesame Salad",
                ],
            ],
            [
                'name' => "Burgers",
                'products' => [
                    "Classic Cheeseburger",
                    "Bacon Avocado Burger",
                    "Mushroom Swiss Burger",
                    "BBQ Burger",
                    "Spicy Jalapeno Burger",
                    "Veggie Burger",
                    "Turkey Burger",
                    "Blue Cheese Burger",
                    "Hawaiian Burger",
                    "Pulled Pork Burger",
                ],
            ],
            [
                'name' => "Sandwiches",
                'products' => [
                    "Club Sandwich",
                    "BLT Sandwich",
                    "Grilled Cheese Sandwich",
                    "Turkey Avocado Sandwich",
                    "Chicken Caesar Wrap",
                    "Reuben Sandwich",
                    "Philly Cheesesteak",
                    "Tuna Salad Sandwich",
                    "Veggie Wrap",
                    "French Dip Sandwich",
                ],
            ],
            [
                'name' => "Pizzas",
                'products' => [
                    "Margherita Pizza",
                    "Pepperoni Pizza",
                    "Vegetarian Pizza",
                    "Meat Lovers Pizza",
                    "Hawaiian Pizza",
                    "BBQ Chicken Pizza",
                    "Mushroom Pizza",
                    "Buffalo Chicken Pizza",
                    "Four Cheese Pizza",
                    "Supreme Pizza",
                ],
            ],
            [
                'name' => "Pasta",
                'products' => [
                    "Spaghetti Bolognese",
                    "Fettuccine Alfredo",
                    "Penne Arrabiata",
                    "Lasagna",
                    "Carbonara",
                    "Pesto Pasta",
                    "Shrimp Scampi",
                    "Chicken Parmesan",
                    "Lobster Ravioli",
                    "Veggie Primavera",
                ],
            ],
            [
                'name' => "Seafood",
                'products' => [
                    "Grilled Salmon",
                    "Fish and Chips",
                    "Lobster Tail",
                    "Shrimp Scampi",
                    "Crab Cakes",
                    "Stuffed Flounder",
                    "Seafood Paella",
                    "Seared Tuna",
                    "Scallops with Garlic Butter",
                    "Miso-Glazed Black Cod",
                ],
            ],
            [
                'name' => "Steaks",
                'products' => [
                    "Filet Mignon",
                    "Ribeye Steak",
                    "New York Strip Steak",
                    "T-Bone Steak",
                    "Porterhouse Steak",
                    "Prime Rib",
                    "Sirloin Steak",
                    "Chateaubriand",
                    "Surf and Turf",
                    "Steak Frites",
                ],
            ],
            [
                'name' => "Chicken",
                'products' => [
                    "Grilled Chicken Breast",
                    "Roasted Chicken",
                    "Chicken Piccata",
                    "Lemon Herb Chicken",
                    "BBQ Chicken",
                    "Chicken Marsala",
                    "Teriyaki Chicken",
                    "Chicken Alfredo",
                    "Chicken Parmesan",
                    "Chicken Kebabs",
                ],
            ],
            [
                'name' => "Vegetarian/Vegan",
                'products' => [
                    "Veggie Stir-Fry",
                    "Tofu Curry",
                    "Vegetable Biryani",
                    "Vegan Pad Thai",
                    "Quinoa Stuffed Peppers",
                    "Eggplant Parmesan",
                    "Falafel Wrap",
                    "Mushroom Risotto",
                    "Vegetable Lasagna",
                    "Vegan Burger",
                ],
            ],
            [
                'name' => "Sushi",
                'products' => [
                    "California Roll",
                    "Spicy Tuna Roll",
                    "Salmon Nigiri",
                    "Tuna Sashimi",
                    "Shrimp Tempura Roll",
                    "Rainbow Roll",
                    "Dragon Roll",
                    "Eel Avocado Roll",
                    "Yellowtail Roll",
                    "Cucumber Roll",
                ],
            ],
            [
                'name' => "Tacos",
                'products' => [
                    "Grilled Chicken Tacos",
                    "Fish Tacos",
                    "Beef Barbacoa Tacos",
                    "Shrimp Tacos",
                    "Vegetable Tacos",
                    "Carnitas Tacos",
                    "Lobster Tacos",
                    "Pork Belly Tacos",
                    "Steak Tacos",
                    "Spicy Tofu Tacos",
                ],
            ],
            [
                'name' => "Wraps",
                'products' => [
                    "Chicken Caesar Wrap",
                    "Mediterranean Wrap",
                    "BBQ Chicken Wrap",
                    "Turkey Club Wrap",
                    "Veggie Wrap",
                    "Buffalo Chicken Wrap",
                    "Falafel Wrap",
                    "Steak and Cheese Wrap",
                    "Grilled Veggie Wrap",
                    "Avocado and Bacon Wrap",
                ],
            ],
            [
                'name' => "Desserts",
                'products' => [
                    "Cheesecake",
                    "Chocolate Brownie",
                    "Apple Pie",
                    "Tiramisu",
                    "Ice Cream Sundae",
                    "Creme Brulee",
                    "Chocolate Mousse",
                    "Fruit Tart",
                    "Key Lime Pie",
                    "Red Velvet Cake",
                ],
            ],
            [
                'name' => "Beverages",
                'products' => [
                    "Soft Drinks",
                    "Iced Tea",
                    "Lemonade",
                    "Coffee",
                    "Hot Tea",
                    "Fruit Juice",
                    "Smoothies",
                    "Milkshakes",
                    "Mocktails",
                    "Mineral Water",
                ],
            ],
            [
                'name' => "Breakfast",
                'products' => [
                    "Pancakes",
                    "French Toast",
                    "Eggs Benedict",
                    "Omelette",
                    "Bagel with Cream Cheese",
                    "Breakfast Burrito",
                    "Waffle",
                    "Granola Parfait",
                    "Croissant",
                    "Breakfast Wrap",
                ],
            ],
        ];
        foreach (FoodCategory::get() as $key => $cat) {
            $cat->products()->delete();
            $cat->delete();
        }
        foreach ($categoriesWithProducts as $category) {
            $storedCategory = FoodCategory::create([
                'name' => $category['name'],
            ]);

            foreach ($category['products'] as $productName) {
                $price = rand(10, 100);
                $cost = rand(1, $price - 3);
                FoodItem::create([
                    'uuid' => Str::orderedUuid(),
                    'name' => $productName,
                    'sku' => Str::slug($productName),
                    'price' => $price,
                    'cost' => $cost,
                    'food_category_id' => $storedCategory->id,
                ]);
            }
        }
        dd('done');
    });
}

Route::get('/opt', function () {
    \Artisan::call('optimize:clear');
    dd(\Artisan::output());
});

Route::get('{all}', [AppController::class, 'index'])
    ->where('all', '^((?!api).)*')
    ->name('index');
